# Charity Notes 13: 拉比Sacks 全球化弊端和慈善的挑战

这节课的内容来自于现代拉比 Jonathan Sacks （曾是英格兰的 Chief Rabbi） 的著作 The Dignity of Difference: How to Avoid the Clash of Civilizations 的一个章节 —— 同情（Compassion）：慈善的概念  。他的这个片段很好的总结了我们这个学期所学内容。我们将会找到圣经和拉比们的慈善模型；也会找到 Maimonides 的关于满足穷人的缺乏（*Dei Mahsaro*）需求，甚至是主观需求的慈善概念。同时关于存款理论也会有所提及：每个人的财富都属于上帝。我们还能看到现代拉比们在全球化和挑战下如何理解这些经典的慈善理论。以下是他文章的观点。



## 全球化的公平和宗教信仰的意义

现在情况比过去更糟的是这些不平等是可见的。当大多数人的视野局限于下一个村庄或城镇时，全世界可能存在不平等现象，但很少有人每天都知道这些不平等现象。<u>全球媒体已经改变了这一切。电视将富人和名人的世界带到最偏远的村庄，同时将饥饿，饥荒，战争和疾病的图像带入我们的起居室。</u>

<u>今天捍卫不平等的力量不可持续</u>。古代和中世纪的世界观是权力财富和地位都是一些命令秩序的一部分，地位是与生俱来的，层次结构也被写入宇宙结构中。现代性是从==命运到选择的转变==，我们再也不能合理地宣称事物的方式是它们注定的方式。

很多国家都为穷人翻身做了大量工作，比如中国的邓小平。但并非每个国家都能获得新技术。它们处于所谓的数字鸿沟（digital divide）的另一边。世界经济政策也始终不利于最贫穷的人。<u>经济自由化可以使强者更强，但弱者弱</u>。金钱比人更流动。流入发展中经济体的资金同样可以迅速流出，造成工业遭受破坏，大量人口失业。投机资本并不总是投资于教育和基础设施。它通常投资于快速增长的行业，助长房地产繁荣，同时保持长期增长不变。斯蒂格利茨（Stiglitz，诺贝尔经济学奖获得者）认为国际货币基金组织（IMF）对贫穷国家实施的一些经济政策，像是在在汹涌的大海上设置<u>小船，即使这些船只声音良好且船长很好，它们也可能被大浪击中并且倾覆</u>。

大多数的跨国公司只追求他们的利益，第一世界公司对第三世界经济体的企业责任已经变得分散且易于回避。一方面公司之间也存在==利益趋同==，另一方面政府寻求==吸引投资==，使工人自己几乎没有权力改变自己的命运。

其他关键人物本身就是民族国家。但他们对国际援助的承诺仍然是矛盾的，尤其是因为过去往往无法接触到有需要的人。它被政府征用，有时用于**支持失败，压迫和独裁的政权**。例如，在非洲，90％的饥饿人口生活在农村地区，但由于非洲大陆的政治精英往往生活在港口城市，农村却遭受忽视。正如一名援助工作者在1984  -  85年饥荒期间所说的那样，“让城市人民挨饿，他们骚乱；让农村人民挨饿，他们就死了。如果你是政治领袖，你会选择哪一个？“ **援助要有效，需要良好的政府，但良好的政府不能通过援助来创造。**

西方政府也不可避免地面临利益冲突。他们的首要职责是保护自己的经济。人们担心，协助发展中国家可能会损害国内福利。<u>几乎所有发达国家的服务业都在扩大，而制造业的数量却在下降。</u> 对于在他们自己国家内是提升就业率还是降低就业率，政府都会三思而后行。

少数繁荣和许多人挨饿的世界，冒犯了我们最深刻的公平和人类团结感。那么全球经济责任的道德基础是什么呢？在这个层面上，**宗教概念比狭隘的政治或经济概念更有帮助**。一神论的核心见解是，<u>如果上帝是人类的父母，那么我们都是一个大家庭的成员</u> - 其影响比以往任何时候都更加真实。启蒙运动为我们提供了普遍权利的概念，但这仍然是一种“薄弱”的道德，在抽象思想中比在道德想象力上更强。更有力的是圣经的观点，那些有需要的人是我们的兄弟姐妹，贫穷是我们在骨子里感受到的。每年逾越节的犹太人都会吃苦难的面包和苦涩的奴隶草药。在Sukkot的节日，他们离开舒适的家园住在小屋 - 住棚节 - 作为一个提醒，没有坚固的屋顶，暴露于元素。<u>伟大的信仰不仅仅是为我们共同的人性提供抽象的表达；他们让我们采取行动，并为其他人对我们的要求提供令人信服的形象。</u>



我想研究一下犹太人的经历，因为它结合了两个与我们现状特别相关的因素。一方面，正如我在前一章所述，犹太教同情==自由市场==，有限政府是个人自由和创造力的最佳防御。另一方面，它从摩西的时代就知道，开放的经济并不能保证在每个人都拥有有==尊严==的存在。以色列早期的宗教是试图建立一个“异质的，无阶级的，分散的部落联盟，被认为是兄弟情谊 - 至少在迦南社会中，作为社会，经济和政治平等的姐妹关系。

在创世纪中，上帝名切了亚布拉罕和他后代的使命：

> 亚伯拉罕必将成为一个伟大而强大的国家，地球上的所有国家都将通过他得到祝福。因为我已经拣选了他，所以他要引导他的孩子和他的家庭跟随他，通过做正确的（tzedakah）和公正的（just, mishpat）是来保持主的道路，以便主会为亚伯拉罕带来他所应许的他。
>
> (Genesis 18: 17-19) 

tzedakah和mishpat这两个词表示不同的正义形式。 Mishpat意味着==惩罚性的==（retributive）正义或法治。相比之下，Tzedakah指的是==分配的==（distributive）正义，一种少量的程序性但更具实质性的（substantive）想法。

tzedakah 这个此很难翻译，他包含了两个词义，正义和慈善。但是这两者有一点点对立的问题。如果我给一个人100欧元，他要么有资格得到，要么没有资格。如果他有，则我的行为是一种正义；如果他没有资格，那这就是慈善行为。在英语（或拉丁语）里，慈善行为并不是正义的行为，正义的行为也不能被描述为慈善事业。因此，Tzedakah 是一个不寻常的术语，它意味着两者。

它起源于犹太教的神学，而犹太教义坚持所有和拥有之间的区别。最终，所有的东西都归（own）上帝所拥有，是世界的创造者。我们所拥有的（possess），但不归我们所有（own）。最明显的例子是利未记的规定：“土地不得永久出售，因为土地是我的;你只是陌生人或与我有关的临时居民”（利未记25:23）。

如果有绝对所有权，那就可以把正义（我们必须给予他人的东西）和慈善（我们从慷慨中给予他人的东西）区别开来。前者是法律上可执行的职责，后者至多是道德义务，是仁慈的。因此，tzedakah意味着通常被称为“==社会正义==”（social justice），意味着所有的人都要有存在的基本条件，并且那些拥有超过他们需要的人必须与那些拥有更少的人**分享一些剩余**。这绝对是以色列人被指责创造的社会的基础，即**每个人都拥有有尊严的生活的基本权利，并在上帝的主权下成为圣约社区中的平等公民**。

以色列人要建造的社会将与他们在埃及所经历的生活形成对比：贫穷，迫害和奴役。他们从束缚中==解放==出来只是他们走向自由之旅的第一阶段。第二个 - 他们与上帝的盟约 - ==集体责任==，以确保没有人被排除在社区及其生活的共同恩惠之外。因此，**圣经坚持认为，自由社会不能仅仅依靠mishpat，法治建立。它还需要tzedakah，**一种公正的资源分配。这种观点与诺贝尔经济学奖获得者阿马蒂亚·森（Amartya Sen）的自由发展概念（development as freedom）密切相关。



## 圣经的集体责任和集体自由

一个社会中，少数人繁荣但许多人挨饿，有些但并非所有人都能获得良好的教育，医疗保健和其他基本设施，不是自由的地方。因为还需要==集体自由==（ collective freedom, cherut）。

圣经是在一个以农业为主的社会的背景下设立的，其条款旨在解决在这种环境中出现的各种贫困问题。第七天所有人都会休息，因此每周有一天所有的经济和政治等级都被暂停。很多的收获措施是留给穷人的，比如田地的角落，被遗忘的捆，以及其他作物的类似措施。（利未记19:9-10，申命记15:1-2）在七年农业周期的第三年和第六年，饥饿者获得了所有产品的十分之一（申命记26:12）。在第七年，当土地上不允许劳动时，农产品属于每个人，“以便你们的穷人可以吃”（出埃及记23:10）。所有未偿还的债务都被取消了（申命记15:1-2）。圣经明确提出这最后的规定可以开放的规避。

债务是一种奴役形式。完全禁止贷款会使人们陷入贫困，剥夺他们开办或维持自己企业的机会。这就是为什么从圣经的角度来看，世界银行目前采取的那种小额贷款至关重要。但是，<u>让债务积累也是错误的：经济体制必须鼓励自由，而不是金融奴隶制</u>。==定期释债==（periodic debt release）是必要的，它使人们能够重新开始，摆脱过去的负担。圣经对贷款人的诉求是坦率的。债务减免不仅是道义上的责任。从长远来看，这是集体繁荣的关键。

禧年的制度背后也有类似的想法。每个人都必须拥有土地。随着时间的推移，一些贫困，不良收成或其他不幸将被迫出售。因此，在第50年的那一年中，所有土地都将归还其原始所有者，以便不会剥夺任何人的祖先遗产。

这些定期再分配证明的是圣经意识到公平分配不会自然地从市场的自由工作中产生。最近一次最有效的国际债务减免运动 Jubilee 2000 直接来自圣经年度的禧年观念并非巧合。它也是英国财政大臣戈登布朗提出的为发展中国家制定“现代马歇尔计划”的提议的基础。



## 后圣经时代和塔木德时代的援助法律

随着大约2000年前的过渡，从圣经到后圣经的犹太教，我们发现更加强调tzedakah，<u>直接提供经济援助，而不是农产品</u>。以色列不再是一个农业经济体，更像是一个小企业和贸易社会，而拉比法则（Rabbinic law）是将圣经原则应用于==新经济环境==的系统性尝试。制定了公共税。建立了新的分配形式，其中包括<u>**每天**分发食物的 tamchui 和**每周**为有需要的人提供资金的 kuppah</u>。tzedakah基金的支付要求高标准的诚信，因此被任命为公共基金的分销商成为社区可以给予的最高荣誉之一。他们将申命记15:8 ”你应该向穷人敞开你的手“ 的内容视为提供了他们被要求解决的贫困类型的定义为==满足他的需要==。

根据这种解释，有两种贫困。第一个满足他的需求（sufficient for his need）指的是绝对的生存水平。在犹太法律中，这被用来包括食物，住房，基本家具以及必要时用于支付婚礼的资金。第二个（“他缺乏的”）意味着**相对贫困**，相对于个人以前而不是指其他人的生活水平。

保护尊严和避免羞辱是犹太教法的系统要素。==自由预示着自尊，因此自由社会将不会剥夺任何人的基本人权。==**自尊的一个要素是独立**。这解释了tzedakah立法的一个显着特征。迈蒙尼德列出了给予他人的各种等级。这项裁决是犹太教内部深刻博弈的结果，因为慈善形式的援助本身对接受者来说是羞辱。因此，tzedakah的最高行为是使得个人自给自足（self-sufficient）。==最高形式的援助是使个人免除援助==。人道主义救济（Humanitarian relief）在短期内至关重要，但**从长远来看，创造就业机会和促进就业更为重要**。

犹太法律的另一个细节也非常有趣，它规定即使是依赖tzedakah的人也必须自己tzedakah。从表面上看，这条规则是荒谬的。然而，拉比所理解的是，奉献是人类尊严的重要组成部分。正如一句非洲谚语所说：给予的手总是最重要的；接收的手总是较低。拉比坚持认为，社区为穷人提供足够的资金，使他们自己也能够给予，这是对人类状况的深刻见解。



## 犹太教的平等观念和社会团结

犹太教代表了对平等观念的高度独特的方法，即不是通过收入或财富甚至机会的平等。也不仅仅是在祷告时我们每个人在上帝面前都有自己的立场，以及在法律面前争执的平等。社会必须确保每个成员平等的尊严：“人类的荣誉”—— 希伯来语是kavod habriyot。在2500多年前生活和工作过的先知，是世界上第一批社会批评家，他们毫不避讳地向国王传递信息并向权力说实话。

他们认为，宗教具有道德，社会和经济层面的影响。它涉及正义，不仅仅是狭隘的法治意识和程序的透明度，而且还涉及赋予社会所有成员一个荣誉地位的实质意义。先知们的教导特点是“团结原则”。在慈善和正义的需求背后，是人民的思想，人民作为一个有机整体，通过选举和契约联合起来！巨大的财富差距，剥削行为，艰苦的就业条件，以及今天所谓的“下层阶级”（underclass）的存在 - 这些都是**人类团结的裂缝**。他们创造了一个分裂的社会。他们将我们共享的东西，都参与其中的共同利益一一摧毁。



## tzedakah 在现代社会的重要性

Tzedakah的重要性在于它并不意味着“慈善”。它不是选择性的，也不取决于给予他人的人的善意。这是一项法律上可执行的义务。它也不依赖于任何特定的经济学说。全球化为参与其中的国家带来了更多的繁荣。我们不会通过摧毁财富创造体系来治愈贫困，正如我们不会通过取消医生来治愈疾病或通过取消法律来终止犯罪。

**新技术和贸易增长是我们最好的且唯一的在全世界消除饥饿，治愈疾病和提高生活水平的希望。** 经济增长比简单的再分配更为重要。任何宗教都不能提出减轻饥饿和疾病的确切政策。它能做的是用人类团结（human solidarity）来共同激励我们以及用犹太传统中的tzedakah和其他信仰的对应物的概念作为构成“公平和公正”的广泛道德模板。与tzedakah一样，目标应该是**恢复国家和个人的尊严和独立**。少数人的自由不能以许多人对贫穷，无知和疾病的奴役为代价。



whzecomjm
2019年7月5日